<?php $__env->startSection('title', 'Products'); ?>
<?php $__env->startSection('page-title', 'Manage Products'); ?>

<?php $__env->startSection('page-actions'); ?>
    <a href="<?php echo e(route('admin.products.create')); ?>"
        class="bg-navy text-gold px-4 py-2 rounded-lg text-sm font-medium hover:bg-navy-light transition-colors">
        + Add Product
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-xl shadow-sm border border-gray-100">
        <!-- Filters -->
        <div class="p-4 border-b border-gray-100">
            <form method="GET" class="flex flex-wrap gap-3">
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search products..."
                    class="px-4 py-2 border rounded-lg text-sm focus:ring-2 focus:ring-gold/20 focus:border-gold">
                <select name="status" class="px-4 py-2 border rounded-lg text-sm">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                </select>
                <select name="stock" class="px-4 py-2 border rounded-lg text-sm">
                    <option value="">All Stock</option>
                    <option value="low" <?php echo e(request('stock') === 'low' ? 'selected' : ''); ?>>Low Stock (&lt;10)</option>
                    <option value="out" <?php echo e(request('stock') === 'out' ? 'selected' : ''); ?>>Out of Stock</option>
                </select>
                <button type="submit" class="bg-gray-100 px-4 py-2 rounded-lg text-sm hover:bg-gray-200">Filter</button>
            </form>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 text-xs text-gray-500 uppercase">
                    <tr>
                        <th class="px-4 py-3 text-left">Product</th>
                        <th class="px-4 py-3 text-right">Price</th>
                        <th class="px-4 py-3 text-center">Stock</th>
                        <th class="px-4 py-3 text-center">Status</th>
                        <th class="px-4 py-3 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3">
                                <p class="font-medium text-navy"><?php echo e($product->name); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e(Str::limit($product->description, 50)); ?></p>
                            </td>
                            <td class="px-4 py-3 text-right font-medium">Rp <?php echo e(number_format($product->price, 0, ',', '.')); ?>

                            </td>
                            <td class="px-4 py-3 text-center">
                                <span
                                    class="px-2 py-1 text-xs font-medium rounded-full <?php echo e($product->stock < 10 ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800'); ?>">
                                    <?php echo e($product->stock); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3 text-center">
                                <?php if($product->is_active): ?>
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full">Active</span>
                                <?php else: ?>
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-gray-100 text-gray-600 rounded-full">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-center">
                                <div class="flex justify-center space-x-2">
                                    <a href="<?php echo e(route('admin.products.edit', $product)); ?>"
                                        class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                    </a>
                                    <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST"
                                        onsubmit="return confirm('Hapus produk ini?')">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="p-2 text-red-600 hover:bg-red-50 rounded-lg">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                </path>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-8 text-center text-gray-400">No products found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="p-4 border-t border-gray-100">
            <?php echo e($products->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sunarta25/gotra/PROTOTYPE/Booking_Moota/resources/views/admin/products/index.blade.php ENDPATH**/ ?>