<?php

use App\Http\Controllers\MootaWebhookController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Moota Webhook (no CSRF, no auth)
Route::post('webhooks/moota', [MootaWebhookController::class, 'handle'])->name('webhooks.moota');

// Payment Verification APIs
Route::post('verify-payment/{orderNumber}', [MootaWebhookController::class, 'verifyPayment'])->name('verify.payment');
Route::post('verify-pending-orders', [MootaWebhookController::class, 'verifyPendingOrders'])->name('verify.pending');
