<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin') - Falala Chocolate</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        navy: { DEFAULT: '#1a2b4b', light: '#2a3b5b', dark: '#0a1b3b' },
                        gold: { DEFAULT: '#c5a059', light: '#e2cf9f', dark: '#a58039' }
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        .sidebar-link.active {
            background: rgba(197, 160, 89, 0.15);
            border-left-color: #c5a059;
        }
    </style>
</head>

<body class="bg-gray-100 min-h-screen">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside class="w-64 bg-navy text-white flex-shrink-0 hidden lg:block">
            <div class="p-6 border-b border-white/10">
                <h1 class="text-gold text-xl font-bold tracking-widest uppercase">Falala</h1>
                <p class="text-gold-light text-xs tracking-[0.2em] uppercase">Admin Panel</p>
            </div>
            <nav class="p-4 space-y-1">
                <a href="{{ route('admin.dashboard') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6">
                        </path>
                    </svg>
                    Dashboard
                </a>
                <a href="{{ route('admin.orders.index') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.orders.*') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2">
                        </path>
                    </svg>
                    Orders
                </a>
                <a href="{{ route('admin.products.index') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.products.*') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    Products
                </a>
                <a href="{{ route('admin.banks.index') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.banks.*') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z">
                        </path>
                    </svg>
                    Banks
                </a>
                <a href="{{ route('admin.locations.index') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.locations.*') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                        </path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Locations
                </a>
                <a href="{{ route('admin.reports.index') }}"
                    class="sidebar-link flex items-center px-4 py-3 rounded-lg hover:bg-white/5 border-l-4 border-transparent transition-all {{ request()->routeIs('admin.reports.*') ? 'active' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                        </path>
                    </svg>
                    Reports
                </a>
            </nav>
            <div class="absolute bottom-0 left-0 w-64 p-4 border-t border-white/10">
                <a href="{{ url('/') }}"
                    class="flex items-center px-4 py-2 text-sm text-gold-light hover:text-gold transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                    </svg>
                    View Booking Form
                </a>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 overflow-y-auto">
            <!-- Mobile Header -->
            <header class="lg:hidden bg-navy text-white p-4 flex justify-between items-center">
                <h1 class="text-gold font-bold">Falala Admin</h1>
                <button id="mobileMenuBtn" class="p-2 hover:bg-white/10 rounded-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </header>

            <!-- Page Header -->
            <div class="bg-white border-b px-6 py-4">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                    <h2 class="text-xl font-bold text-navy">@yield('page-title', 'Dashboard')</h2>
                    <div class="mt-2 sm:mt-0">@yield('page-actions')</div>
                </div>
            </div>

            <!-- Flash Messages -->
            @if(session('success'))
                <div
                    class="mx-6 mt-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg flex items-center justify-between">
                    <span>{{ session('success') }}</span>
                    <button onclick="this.parentElement.remove()"
                        class="text-green-700 hover:text-green-900">&times;</button>
                </div>
            @endif
            @if(session('error'))
                <div
                    class="mx-6 mt-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg flex items-center justify-between">
                    <span>{{ session('error') }}</span>
                    <button onclick="this.parentElement.remove()" class="text-red-700 hover:text-red-900">&times;</button>
                </div>
            @endif
            @if(session('warning'))
                <div
                    class="mx-6 mt-4 bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded-lg flex items-center justify-between">
                    <span>{{ session('warning') }}</span>
                    <button onclick="this.parentElement.remove()"
                        class="text-yellow-700 hover:text-yellow-900">&times;</button>
                </div>
            @endif

            <!-- Page Content -->
            <div class="p-6">
                @yield('content')
            </div>
        </main>
    </div>

    <!-- Mobile Menu Overlay -->
    <div id="mobileMenu" class="fixed inset-0 bg-black/50 z-50 hidden lg:hidden">
        <aside class="w-64 bg-navy h-full">
            <div class="p-4 flex justify-between items-center border-b border-white/10">
                <span class="text-gold font-bold">Menu</span>
                <button onclick="document.getElementById('mobileMenu').classList.add('hidden')"
                    class="text-white">&times;</button>
            </div>
            <nav class="p-4 space-y-1">
                <a href="{{ route('admin.dashboard') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Dashboard</a>
                <a href="{{ route('admin.orders.index') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Orders</a>
                <a href="{{ route('admin.products.index') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Products</a>
                <a href="{{ route('admin.banks.index') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Banks</a>
                <a href="{{ route('admin.locations.index') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Locations</a>
                <a href="{{ route('admin.reports.index') }}"
                    class="flex items-center px-4 py-3 text-white/80 hover:text-white hover:bg-white/5 rounded-lg">Reports</a>
            </nav>
        </aside>
    </div>

    <script>
        document.getElementById('mobileMenuBtn')?.addEventListener('click', () => {
            document.getElementById('mobileMenu').classList.remove('hidden');
        });
    </script>
    @stack('scripts')
</body>

</html>