<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfirmasi Order - Falala Chocolate</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Inter:wght@300;400;500;600&display=swap"
        rel="stylesheet">
    <style>
        :root {
            --navy: #1a2b4b;
            --gold: #c5a059;
            --gold-light: #e2cf9f;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
        }

        .brand-font {
            font-family: 'Playfair Display', serif;
        }

        .bg-navy {
            background-color: var(--navy);
        }

        .text-navy {
            color: var(--navy);
        }

        .text-gold {
            color: var(--gold);
        }
    </style>
</head>

<body class="min-h-screen pb-12">
    <!-- Header -->
    <header class="bg-[#1a2b4b] py-8 mb-8 shadow-lg">
        <div class="container mx-auto px-4 flex flex-col items-center">
            <h1 class="text-[#c5a059] brand-font text-3xl tracking-widest uppercase">Falala</h1>
            <p class="text-[#e2cf9f] tracking-[0.3em] text-xs uppercase mt-1">Chocolate</p>
        </div>
    </header>

    <main class="container mx-auto px-4 max-w-2xl">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden border border-gray-100">
            <div class="p-6 md:p-10">
                <!-- Status Badge -->
                <div class="text-center mb-8" id="statusBadge">
                    @if($order->isExpired())
                        <div
                            class="inline-flex items-center px-4 py-2 bg-red-100 text-red-800 rounded-full text-sm font-semibold">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Pesanan Kadaluarsa
                        </div>
                    @elseif($order->isPending())
                        <div
                            class="inline-flex items-center px-4 py-2 bg-yellow-100 text-yellow-800 rounded-full text-sm font-semibold animate-pulse">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Menunggu Pembayaran
                        </div>
                    @elseif($order->isConfirmed())
                        <div
                            class="inline-flex items-center px-4 py-2 bg-blue-100 text-blue-800 rounded-full text-sm font-semibold">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Pembayaran Dikonfirmasi
                        </div>
                    @else
                        <div
                            class="inline-flex items-center px-4 py-2 bg-green-100 text-green-800 rounded-full text-sm font-semibold">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Selesai
                        </div>
                    @endif
                </div>

                <!-- Pickup Code Display -->
                @if(($order->isConfirmed() || $order->isComplete()) && $order->pickup_code)
                    <div class="bg-gradient-to-r from-[#1a2b4b] to-[#2a3b5b] rounded-2xl p-6 mb-8 text-center">
                        <p class="text-[#e2cf9f] text-xs uppercase tracking-widest mb-2">Kode Pickup Anda</p>
                        <p class="text-4xl font-bold text-white tracking-[0.3em] mb-2">{{ $order->pickup_code }}</p>
                        <p class="text-white/60 text-xs">Tunjukkan kode ini saat mengambil pesanan di store</p>
                    </div>
                @endif

                <h2 class="text-2xl font-bold text-[#1a2b4b] mb-2 text-center brand-font">Konfirmasi Pesanan</h2>
                <p class="text-gray-500 text-center mb-4">Order #{{ $order->order_number }}</p>

                <!-- Save Reminder -->
                <div class="bg-amber-50 border border-amber-200 rounded-xl p-4 mb-8">
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-amber-500 mt-0.5 flex-shrink-0" fill="currentColor"
                            viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <div>
                            <p class="text-sm font-semibold text-amber-800">Simpan halaman ini!</p>
                            <p class="text-xs text-amber-700 mt-1">Simpan link atau screenshot halaman ini untuk
                                memantau status pesanan dan mendapatkan kode pickup Anda.</p>
                            <button onclick="copyLink()"
                                class="mt-2 inline-flex items-center text-xs font-medium text-amber-700 hover:text-amber-900 bg-amber-100 px-3 py-1.5 rounded-lg">
                                <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z">
                                    </path>
                                </svg>
                                Salin Link
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Order Items -->
                <div class="bg-gray-50 rounded-xl p-5 mb-6">
                    <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Detail Pesanan</h3>
                    @foreach($order->items as $item)
                        <div class="flex justify-between py-2 {{ !$loop->last ? 'border-b border-gray-200' : '' }}">
                            <div>
                                <p class="font-medium text-[#1a2b4b]">{{ $item->product_name }}</p>
                                <p class="text-sm text-gray-500">{{ $item->quantity }} x Rp
                                    {{ number_format($item->unit_price, 0, ',', '.') }}
                                </p>
                            </div>
                            <p class="font-semibold text-[#1a2b4b]">Rp {{ number_format($item->subtotal, 0, ',', '.') }}</p>
                        </div>
                    @endforeach
                </div>

                <!-- Amounts -->
                <div class="bg-[#1a2b4b] rounded-xl p-6 text-white mb-6">
                    <div class="flex justify-between mb-2 opacity-70 text-sm">
                        <span>Subtotal</span>
                        <span>Rp {{ number_format($order->subtotal, 0, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between mb-2 opacity-70 text-sm">
                        <span>PPN (11%)</span>
                        <span>Rp {{ number_format($order->ppn, 0, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between mb-4 text-[#e2cf9f] text-sm">
                        <span>Kode Unik</span>
                        <span>+ Rp {{ $order->unique_code }}</span>
                    </div>
                    <div class="h-px bg-white/20 my-4"></div>
                    <div class="flex justify-between">
                        <span class="font-bold uppercase tracking-widest text-sm">Total</span>
                        <span class="text-2xl font-bold text-[#c5a059]">Rp
                            {{ number_format($order->total_amount, 0, ',', '.') }}</span>
                    </div>
                </div>

                <!-- Payment Info -->
                @if($order->isPending())
                    <div class="bg-orange-50 rounded-xl p-5 border border-[#c5a059]/20 mb-6">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Transfer ke Rekening</h3>
                        <div class="bg-white rounded-lg p-4 border border-gray-100">
                            <div class="flex justify-between items-center mb-3">
                                <span class="text-gray-500 text-sm">Bank</span>
                                <span class="font-bold text-[#1a2b4b]">{{ $order->bank->bank_name }}</span>
                            </div>
                            <div class="flex justify-between items-center mb-3">
                                <span class="text-gray-500 text-sm">Nomor Rekening</span>
                                <span
                                    class="font-bold text-[#1a2b4b] tracking-widest">{{ $order->bank->account_number }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-gray-500 text-sm">Atas Nama</span>
                                <span class="font-bold text-[#1a2b4b]">{{ $order->bank->account_name }}</span>
                            </div>
                        </div>
                        <p class="text-xs text-center text-gray-500 mt-4">
                            Harap transfer tepat sesuai nominal <strong class="text-[#c5a059]">Rp
                                {{ number_format($order->total_amount, 0, ',', '.') }}</strong>
                        </p>
                        @if($order->expired_at)
                            <p class="text-xs text-center text-red-500 mt-2">
                                Batas pembayaran: {{ $order->expired_at->format('d M Y, H:i') }} WIB
                            </p>
                        @endif
                    </div>

                    <!-- Upload Payment Proof -->
                    <div class="bg-blue-50 rounded-xl p-5 border border-blue-200 mb-6">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Upload Bukti Transfer</h3>

                        @if(session('success'))
                            <div class="bg-green-100 text-green-800 p-3 rounded-lg text-sm mb-4">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if(session('error'))
                            <div class="bg-red-100 text-red-800 p-3 rounded-lg text-sm mb-4">
                                {{ session('error') }}
                            </div>
                        @endif

                        @if($order->payment_proof)
                            <div class="mb-4">
                                <p class="text-xs text-gray-500 mb-2">Bukti transfer yang diupload:</p>
                                <img src="{{ asset($order->payment_proof) }}" alt="Bukti Transfer"
                                    class="w-full max-h-48 object-contain rounded-lg border border-gray-200">
                                <p class="text-xs text-green-600 mt-2 text-center">✓ Bukti transfer sudah diupload</p>
                            </div>
                        @endif

                        <form action="{{ route('booking.upload-proof', $order->order_number) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="space-y-3">
                                <input type="file" name="payment_proof" accept="image/*" required
                                    class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-[#1a2b4b] file:text-[#c5a059] hover:file:bg-[#2a3b5b]">
                                <p class="text-[10px] text-gray-400">Format: JPG, PNG, WebP. Maks 5MB</p>
                                <button type="submit"
                                    class="w-full bg-[#1a2b4b] text-[#c5a059] py-3 rounded-lg font-semibold text-sm hover:bg-[#2a3b5b] transition-all">
                                    {{ $order->payment_proof ? 'Ganti Bukti Transfer' : 'Upload Bukti Transfer' }}
                                </button>
                            </div>
                        </form>
                    </div>
                @endif

                <!-- Customer Info -->
                <div class="bg-gray-50 rounded-xl p-5 mb-6">
                    <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Informasi Pemesan</h3>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <p class="text-gray-500">Nama</p>
                            <p class="font-medium text-[#1a2b4b]">{{ $order->customer_name }}</p>
                        </div>
                        <div>
                            <p class="text-gray-500">WhatsApp</p>
                            <p class="font-medium text-[#1a2b4b]">{{ $order->customer_whatsapp }}</p>
                        </div>
                        <div class="col-span-2">
                            <p class="text-gray-500">Alamat</p>
                            <p class="font-medium text-[#1a2b4b]">{{ $order->customer_address }}</p>
                        </div>
                        <div>
                            <p class="text-gray-500">Lokasi Pickup</p>
                            <p class="font-medium text-[#1a2b4b]">{{ $order->storeLocation->name }}</p>
                        </div>
                        @if($order->notes)
                            <div>
                                <p class="text-gray-500">Catatan</p>
                                <p class="font-medium text-[#1a2b4b]">{{ $order->notes }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Actions -->
                <div class="flex flex-col sm:flex-row gap-3">
                    <a href="{{ url('/') }}"
                        class="flex-1 text-center py-3 px-6 border-2 border-[#1a2b4b] text-[#1a2b4b] rounded-xl font-semibold hover:bg-[#1a2b4b] hover:text-white transition-all">
                        Order Lagi
                    </a>
                    <a href="https://wa.me/{{ preg_replace('/^0/', '62', $order->customer_whatsapp) }}"
                        class="flex-1 text-center py-3 px-6 bg-green-500 text-white rounded-xl font-semibold hover:bg-green-600 transition-all flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" />
                        </svg>
                        Hubungi via WhatsApp
                    </a>
                </div>
            </div>
        </div>

        <p class="text-center text-gray-400 text-[10px] uppercase tracking-widest mt-10">
            Falala Chocolate &copy; {{ date('Y') }}. Handcrafted in Bali.
        </p>
    </main>

    @if($order->isPending())
        <script>
            // Auto-refresh status every 30 seconds
            setInterval(function () {
                fetch('{{ route("booking.status", $order->order_number) }}')
                    .then(response => response.json())
                    .then(data => {
                        if (data.is_paid) {
                            // Reload page to show updated status
                            window.location.reload();
                        } else if (data.is_expired) {
                            window.location.reload();
                        }
                    })
                    .catch(err => console.log('Status check failed'));
            }, 30000);
        </script>
    @endif

    <script>
        function copyLink() {
            navigator.clipboard.writeText(window.location.href);
            alert('Link berhasil disalin! Simpan link ini untuk cek status pesanan.');
        }
    </script>
</body>

</html>