@extends('layouts.admin')

@section('title', 'Add Product')
@section('page-title', 'Add New Product')

@section('content')
    <div class="max-w-2xl">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <form action="{{ route('admin.products.store') }}" method="POST">
                @csrf
                <div class="space-y-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Product Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold @error('name') border-red-500 @enderror">
                        @error('name')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <textarea name="description" rows="3"
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">{{ old('description') }}</textarea>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Price (Rp) <span
                                    class="text-red-500">*</span></label>
                            <input type="number" name="price" value="{{ old('price', 0) }}" min="0" step="1000" required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Stock <span
                                    class="text-red-500">*</span></label>
                            <input type="number" name="stock" value="{{ old('stock', 0) }}" min="0" required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', true) ? 'checked' : '' }} class="w-4 h-4 accent-navy rounded">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Active (visible in booking form)</label>
                    </div>
                </div>
                <div class="mt-6 flex justify-end space-x-3">
                    <a href="{{ route('admin.products.index') }}"
                        class="px-4 py-2 border rounded-lg text-gray-600 hover:bg-gray-50">Cancel</a>
                    <button type="submit" class="px-4 py-2 bg-navy text-gold rounded-lg hover:bg-navy-light">Save
                        Product</button>
                </div>
            </form>
        </div>
    </div>
@endsection