@extends('layouts.admin')

@section('title', 'Orders')
@section('page-title', 'Manage Orders')

@section('page-actions')
    <a href="{{ route('admin.orders.export', request()->query()) }}"
        class="bg-gray-100 text-navy px-4 py-2 rounded-lg text-sm font-medium hover:bg-gray-200 transition-colors">
        Export CSV
    </a>
@endsection

@section('content')
    <div class="bg-white rounded-xl shadow-sm border border-gray-100">
        <!-- Filters -->
        <div class="p-4 border-b border-gray-100">
            <form method="GET" class="flex flex-wrap gap-3">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search order/customer..."
                    class="px-4 py-2 border rounded-lg text-sm w-48">
                <select name="status" class="px-4 py-2 border rounded-lg text-sm">
                    <option value="">All Status</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="confirm" {{ request('status') === 'confirm' ? 'selected' : '' }}>Confirmed</option>
                    <option value="complete" {{ request('status') === 'complete' ? 'selected' : '' }}>Complete</option>
                </select>
                <select name="store_location_id" class="px-4 py-2 border rounded-lg text-sm">
                    <option value="">All Locations</option>
                    @foreach($storeLocations as $loc)
                        <option value="{{ $loc->id }}" {{ request('store_location_id') == $loc->id ? 'selected' : '' }}>
                            {{ $loc->name }}</option>
                    @endforeach
                </select>
                <input type="date" name="date_from" value="{{ request('date_from') }}"
                    class="px-4 py-2 border rounded-lg text-sm">
                <input type="date" name="date_to" value="{{ request('date_to') }}"
                    class="px-4 py-2 border rounded-lg text-sm">
                <button type="submit" class="bg-gray-100 px-4 py-2 rounded-lg text-sm hover:bg-gray-200">Filter</button>
            </form>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 text-xs text-gray-500 uppercase">
                    <tr>
                        <th class="px-4 py-3 text-left">Order</th>
                        <th class="px-4 py-3 text-left">Customer</th>
                        <th class="px-4 py-3 text-left">Location</th>
                        <th class="px-4 py-3 text-right">Total</th>
                        <th class="px-4 py-3 text-center">Status</th>
                        <th class="px-4 py-3 text-center">Date</th>
                        <th class="px-4 py-3 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($orders as $order)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3">
                                <a href="{{ route('admin.orders.show', $order) }}"
                                    class="font-medium text-navy hover:text-gold">{{ $order->order_number }}</a>
                            </td>
                            <td class="px-4 py-3">
                                <p class="text-sm">{{ $order->customer_name }}</p>
                                <p class="text-xs text-gray-400">{{ $order->customer_whatsapp }}</p>
                            </td>
                            <td class="px-4 py-3 text-sm">{{ $order->storeLocation->name ?? '-' }}</td>
                            <td class="px-4 py-3 text-right font-medium">Rp
                                {{ number_format($order->total_amount, 0, ',', '.') }}</td>
                            <td class="px-4 py-3 text-center">
                                @if($order->status === 'pending')
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-yellow-100 text-yellow-800 rounded-full">Pending</span>
                                @elseif($order->status === 'confirm')
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-blue-100 text-blue-800 rounded-full">Confirm</span>
                                @else
                                    <span
                                        class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full">Complete</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-center text-sm text-gray-500">
                                {{ $order->created_at->format('d/m/y H:i') }}</td>
                            <td class="px-4 py-3 text-center">
                                <a href="{{ route('admin.orders.show', $order) }}"
                                    class="inline-flex p-2 text-blue-600 hover:bg-blue-50 rounded-lg">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                        </path>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-8 text-center text-gray-400">No orders found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="p-4 border-t border-gray-100">{{ $orders->links() }}</div>
    </div>
@endsection