@extends('layouts.admin')

@section('title', 'Add Location')
@section('page-title', 'Add Store Location')

@section('content')
    <div class="max-w-2xl">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <form action="{{ route('admin.locations.store') }}" method="POST">
                @csrf
                <div class="space-y-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Location Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <textarea name="description" rows="3"
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">{{ old('description') }}</textarea>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Google Maps Link</label>
                        <input type="url" name="gmap_link" value="{{ old('gmap_link') }}"
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold"
                            placeholder="https://maps.google.com/...">
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', true) ? 'checked' : '' }} class="w-4 h-4 accent-navy rounded">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Active</label>
                    </div>
                </div>
                <div class="mt-6 flex justify-end space-x-3">
                    <a href="{{ route('admin.locations.index') }}"
                        class="px-4 py-2 border rounded-lg text-gray-600 hover:bg-gray-50">Cancel</a>
                    <button type="submit" class="px-4 py-2 bg-navy text-gold rounded-lg hover:bg-navy-light">Save
                        Location</button>
                </div>
            </form>
        </div>
    </div>
@endsection