@extends('layouts.admin')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
    <div class="space-y-6">
        <!-- Stats Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Order Hari Ini</p>
                        <p class="text-3xl font-bold text-navy">{{ number_format($todayOrders) }}</p>
                    </div>
                    <div class="w-12 h-12 bg-gold/10 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Pendapatan Hari Ini</p>
                        <p class="text-2xl font-bold text-navy">Rp {{ number_format($todayRevenue, 0, ',', '.') }}</p>
                    </div>
                    <div class="w-12 h-12 bg-green-500/10 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                            </path>
                        </svg>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Order Pending</p>
                        <p class="text-3xl font-bold text-yellow-600">{{ number_format($pendingOrders) }}</p>
                    </div>
                    <div class="w-12 h-12 bg-yellow-500/10 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Total Order</p>
                        <p class="text-3xl font-bold text-navy">{{ number_format($totalOrders) }}</p>
                    </div>
                    <div class="w-12 h-12 bg-blue-500/10 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2">
                            </path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Recent Orders -->
            <div class="lg:col-span-2 bg-white rounded-xl shadow-sm border border-gray-100">
                <div class="p-4 border-b border-gray-100 flex justify-between items-center">
                    <h3 class="font-semibold text-navy">Order Terbaru</h3>
                    <a href="{{ route('admin.orders.index') }}" class="text-sm text-gold hover:underline">Lihat Semua</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 text-xs text-gray-500 uppercase">
                            <tr>
                                <th class="px-4 py-3 text-left">Order</th>
                                <th class="px-4 py-3 text-left">Customer</th>
                                <th class="px-4 py-3 text-right">Total</th>
                                <th class="px-4 py-3 text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @forelse($recentOrders as $order)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3">
                                        <a href="{{ route('admin.orders.show', $order) }}"
                                            class="font-medium text-navy hover:text-gold">{{ $order->order_number }}</a>
                                        <p class="text-xs text-gray-400">{{ $order->created_at->format('d M H:i') }}</p>
                                    </td>
                                    <td class="px-4 py-3">
                                        <p class="text-sm">{{ $order->customer_name }}</p>
                                        <p class="text-xs text-gray-400">{{ $order->storeLocation->name ?? '-' }}</p>
                                    </td>
                                    <td class="px-4 py-3 text-right font-medium">Rp
                                        {{ number_format($order->total_amount, 0, ',', '.') }}</td>
                                    <td class="px-4 py-3 text-center">
                                        @if($order->status === 'pending')
                                            <span
                                                class="px-2 py-1 text-xs font-medium bg-yellow-100 text-yellow-800 rounded-full">Pending</span>
                                        @elseif($order->status === 'confirm')
                                            <span
                                                class="px-2 py-1 text-xs font-medium bg-blue-100 text-blue-800 rounded-full">Confirm</span>
                                        @else
                                            <span
                                                class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full">Complete</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-4 py-8 text-center text-gray-400">Belum ada order</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Sidebar Info -->
            <div class="space-y-6">
                <!-- Webhook URL -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
                    <h3 class="font-semibold text-navy mb-3 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1">
                            </path>
                        </svg>
                        Moota Webhook URL
                    </h3>
                    <div class="bg-gray-50 rounded-lg p-3 flex items-center justify-between">
                        <code id="webhookUrl" class="text-xs text-gray-600 break-all">{{ $webhookUrl }}</code>
                        <button onclick="copyWebhook()"
                            class="ml-2 p-2 text-gold hover:bg-gold/10 rounded-lg flex-shrink-0">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3">
                                </path>
                            </svg>
                        </button>
                    </div>
                    <p class="text-xs text-gray-400 mt-2">Tambahkan URL ini di dashboard Moota untuk menerima notifikasi
                        pembayaran.</p>
                </div>

                <!-- Low Stock Products -->
                @if($lowStockProducts->count() > 0)
                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
                        <h3 class="font-semibold text-navy mb-3 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                </path>
                            </svg>
                            Stok Menipis
                        </h3>
                        <div class="space-y-2">
                            @foreach($lowStockProducts as $product)
                                <div class="flex justify-between items-center p-2 bg-red-50 rounded-lg">
                                    <span class="text-sm">{{ $product->name }}</span>
                                    <span class="text-sm font-bold text-red-600">{{ $product->stock }}</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Quick Stats -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
                    <h3 class="font-semibold text-navy mb-3">Status Overview</h3>
                    <div class="space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-500">Pending</span>
                            <span class="font-medium text-yellow-600">{{ $pendingOrders }}</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-500">Confirmed</span>
                            <span class="font-medium text-blue-600">{{ $confirmedOrders }}</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-500">Completed</span>
                            <span class="font-medium text-green-600">{{ $completedOrders }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            function copyWebhook() {
                const url = document.getElementById('webhookUrl').innerText;
                navigator.clipboard.writeText(url).then(() => {
                    alert('Webhook URL berhasil disalin!');
                });
            }
        </script>
    @endpush
@endsection