@extends('layouts.admin')

@section('title', 'Edit Bank')
@section('page-title', 'Edit Bank')

@section('content')
    <div class="max-w-2xl">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <form action="{{ route('admin.banks.update', $bank) }}" method="POST">
                @csrf @method('PUT')
                <div class="space-y-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Moota Bank ID</label>
                        <input type="text" name="moota_bank_id" value="{{ old('moota_bank_id', $bank->moota_bank_id) }}"
                            required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Bank Name</label>
                        <input type="text" name="bank_name" value="{{ old('bank_name', $bank->bank_name) }}" required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Account Number</label>
                            <input type="text" name="account_number"
                                value="{{ old('account_number', $bank->account_number) }}" required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Account Name</label>
                            <input type="text" name="account_name" value="{{ old('account_name', $bank->account_name) }}"
                                required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', $bank->is_active) ? 'checked' : '' }} class="w-4 h-4 accent-navy rounded">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Active</label>
                    </div>
                </div>
                <div class="mt-6 flex justify-end space-x-3">
                    <a href="{{ route('admin.banks.index') }}"
                        class="px-4 py-2 border rounded-lg text-gray-600 hover:bg-gray-50">Cancel</a>
                    <button type="submit" class="px-4 py-2 bg-navy text-gold rounded-lg hover:bg-navy-light">Update
                        Bank</button>
                </div>
            </form>
        </div>
    </div>
@endsection