@extends('layouts.admin')

@section('title', 'Add Bank')
@section('page-title', 'Add New Bank')

@section('content')
    <div class="max-w-2xl">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <form action="{{ route('admin.banks.store') }}" method="POST">
                @csrf
                <div class="space-y-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Moota Bank ID <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="moota_bank_id" value="{{ old('moota_bank_id') }}" required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold @error('moota_bank_id') border-red-500 @enderror"
                            placeholder="e.g., abcd1234">
                        @error('moota_bank_id')<p class="text-red-500 text-xs mt-1">{{ $message }}</p>@enderror
                        <p class="text-xs text-gray-400 mt-1">ID dari dashboard Moota</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Bank Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="bank_name" value="{{ old('bank_name') }}" required
                            class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold"
                            placeholder="e.g., BCA, Mandiri">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Account Number <span
                                    class="text-red-500">*</span></label>
                            <input type="text" name="account_number" value="{{ old('account_number') }}" required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Account Name <span
                                    class="text-red-500">*</span></label>
                            <input type="text" name="account_name" value="{{ old('account_name') }}" required
                                class="w-full px-4 py-3 border rounded-lg focus:ring-2 focus:ring-gold/20 focus:border-gold">
                        </div>
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', true) ? 'checked' : '' }} class="w-4 h-4 accent-navy rounded">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Active</label>
                    </div>
                </div>
                <div class="mt-6 flex justify-end space-x-3">
                    <a href="{{ route('admin.banks.index') }}"
                        class="px-4 py-2 border rounded-lg text-gray-600 hover:bg-gray-50">Cancel</a>
                    <button type="submit" class="px-4 py-2 bg-navy text-gold rounded-lg hover:bg-navy-light">Save
                        Bank</button>
                </div>
            </form>
        </div>
    </div>
@endsection