<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('unique_codes', function (Blueprint $table) {
            $table->id();
            $table->unsignedSmallInteger('code');
            $table->decimal('base_amount', 15, 2);
            $table->foreignId('order_id')->nullable()->constrained()->nullOnDelete();
            $table->enum('status', ['available', 'reserved', 'used', 'expired'])->default('available');
            $table->timestamp('reserved_at')->nullable();
            $table->timestamp('expires_at')->nullable()->index();
            $table->timestamps();

            // Ensure unique code + base_amount combination when in use
            $table->unique(['code', 'base_amount', 'status']);
            $table->index(['base_amount', 'status', 'expires_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('unique_codes');
    }
};
