<?php

namespace App\Jobs;

use App\Services\OrderService;
use App\Services\UniqueCodeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class CleanupExpiredOrdersJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(
        OrderService $orderService,
        UniqueCodeService $uniqueCodeService,
    ): void {
        // Expire old orders
        $expiredOrders = $orderService->expireOldOrders();
        Log::info("Expired {$expiredOrders} old orders");

        // Cleanup expired unique codes
        $expiredCodes = $uniqueCodeService->cleanupExpiredCodes();
        Log::info("Cleaned up {$expiredCodes} expired unique codes");
    }
}
